
//-------------------------------------------
#declare plant = union{
#declare Inc =0
#declare Count = 0
#declare Rad = 0.25
#declare X = 0.1

#while (Count<120)
   object{torus{exp(X*2.5)*2,1}
                   translate <X,Inc,0>
                   rotate (X*-Inc)/4
                   }
      #declare Inc = Inc + 0.5
      #declare Count = Count + 1
      #declare Rad = Rad + 0.1
      #declare X = X + 0.01
   #end
}
//---------------------------------------------
#declare Plant_Texture = texture{
      pigment{
           bozo color_map{
                      [0.00 color Cyan ]
                      [0.20 color Green ]
                      [0.30 color Yellow ]
                      [0.45 color Cyan ]
                      [0.65 color ForestGreen]
                      [0.75 color Cyan ]
                      [0.90 color Yellow]}
                      frequency 3
                      turbulence 3
                      rotate x*90
                }
         finish{
            specular 1
            roughness 0.01
               }
         normal{
            radial 3
            turbulence 0.15
            frequency 35
            scallop_wave
               }
}   //end of tex def

//---------------------------------------------
#declare FlowerTex = texture{
pigment{
gradient y
  color_map
   {[0.000, 0.5  color rgb <0,1,1>
                    color rgb <1,1,1>]
    [0.5, 1.00   color rgb <1,1,1>
                    color rgb <1,1,1>]
 }
   scale 0.5
 }
 //normal{waves 5 frequency 5 scale 0.5}
 finish{ambient 0.3 diffuse 0.6 specular 1 roughness 0.1}
 }
 #declare FlowerTex2 = texture{
pigment{
gradient y
  color_map
   {[0.000, 0.3  color rgb <0,1,1>
                    color rgb <1,1,1>]
    [0.3, 1.00   color rgb <1,1,1>
                    color rgb <0,1,1>]
   }
   scale 0.5
 }
 //normal{waves 5 frequency 5 scale 0.5}
 finish{ambient 0.3 diffuse 0.6 specular 1 roughness 0.1}
 }
//----------------------------------------------------------
// bicubic_patch: Petal2
//----------------------------------------------------------
#declare Petal = object{
bicubic_patch  {
   type	1
   flatness	0.01
   u_steps	4
   v_steps	4
   <-3.726, 1.574, -2.363>,
   <-1.323, 2.969, -1.814>,
   <1.327, 3.019, -1.914>,
   <5.216, 1.922, -2.088>,
   <-5.856, 0.228, -3.135>,
   <-2.611, 1.026, 0.000>,
   <1.971, 1.026, 0.000>,
   <10.170, 0.403, -2.960>,
   <-5.707, -0.145, -3.135>,
   <-2.611, -1.067, 0.000>,
   <2.021, -1.142, 0.000>,
   <9.972, -0.444, -2.886>,
   <-3.528, -1.615, -2.288>,
   <-1.224, -2.911, -1.814>,
   <1.501, -2.911, -1.790>,
   <5.464, -2.064, -2.188>
}
rotate x*-270
rotate z*20
}


#declare Flower = union{
#declare Turns = 0
#declare Count = 0
#declare Rad = 0.5
#declare Vangle = 0
#declare Rotinc = 0
#declare Petscale = 0.1

#while (Turns<4)
       #while (Count<360)

          object{Petal
                      scale Petscale
                      #if (Turns = 3)texture{FlowerTex2} #else texture{FlowerTex}#end
                      translate <Rad,0,0>
                      rotate z*Vangle
                      rotate y*Rotinc
      }

            #declare Count = Count + 60
            #declare Rotinc = Rotinc + 60
         #end

    #if(Turns = 1) #declare Vangle = Vangle + 10 #end
    #if(Turns = 2) #declare Vangle = Vangle + 35 #end
    #if(Turns = 3) #declare Vangle = Vangle + 65 #end
    #declare Turns = Turns + 1
    #declare Count = 0
    #if (Turns = 1) #declare Rotinc = 30 #end
    #if (Turns = 2) #declare Rotinc = 45 #end
    #if (Turns = 3) #declare Rotinc = 15 #end
    #if (Turns = 1) #declare Petscale = 0.085 #end
    #if (Turns = 2) #declare Petscale = 0.07 #end
     #if (Turns = 3) #declare Petscale = 0.065 #end
#end
}
#declare Water_Lilly = union{
object {Flower translate<0,-0.5,0>}
object {Flower scale 0.5 translate<-2.5,-0.5,-3>}
object {Flower scale 0.75 translate<3,-0.5,-1>}

object{plant
scale<1,0.1,1>
texture{Plant_Texture}
scale 0.03
rotate y*180
rotate x*-5
translate<-1.25,-0.5,0>
}

object{plant
scale<0.75,0.1,1>
texture{Plant_Texture}
scale 0.03
rotate y*70
rotate x*-5
translate<0.5,-0.5,0>
}
object{plant
scale<0.65,0.1,0.65>
texture{Plant_Texture}
scale 0.03
rotate y*120
rotate x*-5
translate<2.5,-0.5,1>
}
object{plant
scale<0.5,0.1,0.5>
texture{Plant_Texture}
scale 0.03
rotate y*200
rotate x*2.5
translate<-3.25,-0.5,-2>
}
object{plant
scale<1,0.1,1>
texture{Plant_Texture}
scale 0.03
rotate y*200
rotate x*-5
translate<0,-0.5,2>
}
object{plant
scale<1,0.1,1>
texture{Plant_Texture}
scale 0.03
rotate y*120
rotate x*2.5
translate<0.5,-0.55,-3.5>
}
}


